/*
 * Copyright (c) 2017 by IT Modernisation Services GmbH
 * Hamburg, Germany.  All rights reserved.
 */
package com.itms.demo.generali;

import com.itms.demo.generali.model.*;
import com.itms.demo.generali.service.ModelInstanceHolder;

import java.util.Arrays;

/**
 * @author IT Modernisation Services GmbH
 *
 *          Entity       ARQ991
 *          Transformer  IT Modernisation Services GmbH
 *                       Hamburg, Germany
 *          On           17.06.2017
 *          Using        njema Version 4.4
 */
public class ARQ991 {

    public ARQ991 () {
        REGWEB_SAL regwebSal = ((REGWEB_SAL) ModelInstanceHolder.getCurrentModelInstance("REGWEB_SAL"));
        INFO_0001 info_0001 = new INFO_0001();
        INFO_0011 info_0011 = new INFO_0011();
        REGENT regent = ((REGENT)ModelInstanceHolder.getCurrentModelInstance("REGENT"));

        /* MOVEM L'AREA REBUDA AL REGISTRE WW0011 */
        WW0001 ww0001 = new WW0001();
        ww0001.setAll(Arrays.toString(regent.getRegweb1()));
        WW0011 ww0011 = new WW0011();
        ww0011.setAll(Arrays.toString(regent.getRegweb2()));
        ww0001.setRespos("RESP0001".toCharArray());
        ww0011.setRespos("RESP0011".toCharArray());
        info_0001.setLngreg0001((short) 10);
        info_0011.setLngreg0011((short) 10);
        regwebSal.setRegwebSal((info_0001.toString() + ww0001.toString() + info_0011.toString() + ww0011.toString()).toCharArray());
        /* @WEBERROR('RED',1368,WW0001@@.RESPOS@@); */
        TWA twa = ((TWA)ModelInstanceHolder.getCurrentModelInstance("TWA"));
        twa.setLongms((short) ww0001.toString().length());
        twa.setLongms((short) (24 + twa.getLongms() + ww0011.toString().length()));
        /* EXEC CICS XCTL PROGRAM('STS016'); */
    }
}
