/*
 * Copyright (c) 2016 by IT Modernisation Services GmbH
 *  Hamburg, Germany.  All rights reserved.
 */
package com.itms.demo.generali.service;

import java.lang.reflect.Constructor;
import java.util.HashMap;

/**
 * @author JFire
 * @version $Revision$ $Date$
 *          Entity       ModelInstanceHolder
 *          Transformed  by IT Modernisation Services GmbH
 *          Hamburg, Germany
 *          On           $Date$
 *          Using        JFire Version 1.2
 *          JFire is a RULAMAN(r) based product
 */
public class ModelInstanceHolder {

    private static HashMap<String, Class> modelInstances;

    public ModelInstanceHolder () {
    }

    private static HashMap getModelInstances() {
        if (modelInstances == null) {
            modelInstances = new HashMap<String, Class>();
        }

        return modelInstances;
    }

    public static Object getCurrentModelInstance(String className) {
        if (getModelInstances().containsKey(className)) {
            return getModelInstances().get(className);
        } else {
            try {
                Class clazz = Class.forName(className);
                Constructor<?> ctor = clazz.getConstructor(String.class);
                return ctor.newInstance();
            } catch (Exception e) {
                System.out.println(e.getMessage() + ": " + e);
                return new Object();
            }
        }
    }
}
