/*
 * Copyright (c) 2017 by IT Modernisation Services GmbH
 * Hamburg, Germany.  All rights reserved.
 */

package com.itms.demo.oews.common.service;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Locale;

/**
 * @author Thilo Dreyer
 * IT Modernisation Services GmbH
 * Hamburg, Germany
 */
@Service
@PropertySource("classpath:global.properties")
public class BuiltinFunctions {

    @Value("${dateTimePattern}")
    private String dateTimePattern;

    public String getDateTime() {
        DateFormatter formatter = new DateFormatter(dateTimePattern);
        Date now = new Date();
        return formatter.print(now, Locale.getDefault());
    }

    public String pictureToString(Integer value, Integer number) {
        StringBuilder result = new StringBuilder(String.valueOf(value));
        while (result.length() < number) {
            result.insert(0, "0");
        }

        return result.toString();
    }
}
