/*
 * Copyright (c) 2017 by IT Modernisation Services GmbH
 * Hamburg, Germany.  All rights reserved.
 */

package com.itms.demo.oews.common.service;

import com.itms.demo.oews.common.model.ExecuteSqlResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * @author Thilo Dreyer
 * IT Modernisation Services GmbH
 * Hamburg, Germany
 */
@Service
public class DBFunctions {

    @Autowired
    private DataSourceTransactionManager transactionManager;

    public ExecuteSqlResult executeSql(String query, RowMapper mapper) {
        DataSource dataSource;
        Connection connection = null;
        try {
            dataSource = transactionManager.getDataSource();
            connection = dataSource.getConnection();

            Statement statement = connection.createStatement();
            statement.execute(query);
            ResultSet rs = statement.getResultSet();
            if (rs != null) {
                while (rs.next()) {
                    mapper.mapRow(rs, rs.getRow());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (connection != null) {
                try {
                    connection.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}
