/*
 * Copyright (c) 2017 by IT Modernisation Services GmbH
 * Hamburg, Germany.  All rights reserved.
 */

package com.itms.demo.oews.common.service;

import org.springframework.stereotype.Service;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author Thilo Dreyer
 * IT Modernisation Services GmbH
 * Hamburg, Germany
 */
@Service
public class FileFunctions {

    private Map<String, File> fileHolder; // REPLACE WITH OBJECT FOR FILE AND STREAMS

    public String getIdentifier() {
        UUID uniqueKey = UUID.randomUUID();
        return uniqueKey.toString();
    }

    public void writeToFile(String fileName, String identifier, String wmMeldungC) throws Exception {
        // check if file exists, create if not
        // write content in file
    }

    public String readLineFromFile(String fileName, String identifier) {
        return "";
    }

    public boolean hasMore(String fileName, String identifier) {
        return true;
    }

    public void openFile(String fileName, String identifier) {
        if (!haveFile(fileName, identifier)) {
            File file = new File(fileName); // CENTRAL PLACE / FOLDER
            fileHolder.put(fileName + identifier, file);
        }
    }

    public void closeFile(String fileName, String identifier) {
        File file = fileHolder.get(fileName + identifier);
        fileHolder.remove(fileName + identifier);
    }

    private boolean haveFile(String fileName, String identifier) {
        if (fileHolder == null) {
            fileHolder = new HashMap<>();
        }
        return fileHolder.containsKey(fileName + identifier);
    }
}
