/*
 * Copyright (c) 2017 by IT Modernisation Services GmbH
 * Hamburg, Germany.  All rights reserved.
 */

import com.itms.demo.generali.AVLUtils;
import com.itms.demo.generali.model.AvlNode;
import com.itms.demo.generali.model.ElementType;
import org.junit.Assert;
import org.junit.Test;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.IsNot.not;

/**
 * @author Thilo Dreyer
 *         IT Modernisation Services GmbH
 *         Hamburg, Germany
 */
public class TestAVLUtils {

    @Test
    public void testMakeEmpty() {
        AVLUtils avlUtils = new AVLUtils();
        AvlNode node = new AvlNode();

        node = avlUtils.makeEmpty(node);
        Assert.assertThat(node, equalTo(null));
    }

    @Test
    public void testMakeEmptyGP() {
        AVLUtils avlUtils = new AVLUtils();
        AvlNode node = new AvlNode();

        node = avlUtils.makeEmptyGP(node);
        Assert.assertThat(node, equalTo(null));
    }

    @Test
    public void testDelete() {
        AVLUtils avlUtils = new AVLUtils();
        AvlNode node = new AvlNode();
        ElementType type = new ElementType();
        type.setKey(1);
        node.setElement(type);

        AvlNode node2 = avlUtils.delete(new ElementType(), node);
        Assert.assertThat(node, equalTo(node2));
    }

    @Test
    public void testRetrieve() {
        AVLUtils avlUtils = new AVLUtils();
        AvlNode node = new AvlNode();
        ElementType type = new ElementType();
        type.setKey(2);
        node.setElement(type);

        ElementType type2 = avlUtils.retrieve(node);
        Assert.assertThat(type, equalTo(type2));
    }

    @Test
    public void testPrintTree() {
        AVLUtils avlUtils = new AVLUtils();
        AvlNode tree = new AvlNode();
        ElementType type = new ElementType();
        type.setKey(1);
        tree.setElement(type);
        tree.setHeight(1);
        tree.setBalance(2);

        AvlNode left = new AvlNode();
        ElementType typeLeft = new ElementType();
        typeLeft.setKey(2);
        left.setElement(typeLeft);
        left.setHeight(1);
        left.setBalance(0);
        tree.setLeft(left);

        AvlNode right = new AvlNode();
        ElementType typeRight = new ElementType();
        typeRight.setKey(3);
        right.setElement(typeRight);
        right.setHeight(1);
        right.setBalance(0);
        tree.setRight(right);

        avlUtils.printTree(tree);
    }

    @Test
    public void testHeight() {
        AVLUtils avlUtils = new AVLUtils();
        AvlNode tree = new AvlNode();
        ElementType type = new ElementType();
        type.setKey(1);
        tree.setElement(type);
        tree.setHeight(4);
        tree.setBalance(2);

        Integer height = avlUtils.height(tree);
        Assert.assertThat(height, equalTo(4));
    }

    @Test
    public void testInsert() {
        AVLUtils avlUtils = new AVLUtils();
        AvlNode tree = null;
        ElementType type = new ElementType();
        type.setKey(1);
        tree = avlUtils.insert(type, tree);

        Assert.assertThat(tree, not(equalTo(null)));
    }

    @Test
    public void testFindMin() {
        AVLUtils avlUtils = new AVLUtils();
        AvlNode tree = new AvlNode();
        ElementType type = new ElementType();
        type.setKey(1);
        tree.setElement(type);
        tree.setHeight(1);
        tree.setBalance(2);

        AvlNode left = new AvlNode();
        ElementType typeLeft = new ElementType();
        typeLeft.setKey(2);
        left.setElement(typeLeft);
        left.setHeight(1);
        left.setBalance(0);
        tree.setLeft(left);

        AvlNode right = new AvlNode();
        ElementType typeRight = new ElementType();
        typeRight.setKey(3);
        right.setElement(typeRight);
        right.setHeight(1);
        right.setBalance(0);
        tree.setRight(right);

        AvlNode min = avlUtils.findMin(tree);
        Assert.assertThat(min.getKey(), equalTo(2));
    }

    @Test
    public void testFindMax() {
        AVLUtils avlUtils = new AVLUtils();
        AvlNode tree = new AvlNode();
        ElementType type = new ElementType();
        type.setKey(1);
        tree.setElement(type);
        tree.setHeight(1);
        tree.setBalance(2);

        AvlNode left = new AvlNode();
        ElementType typeLeft = new ElementType();
        typeLeft.setKey(2);
        left.setElement(typeLeft);
        left.setHeight(1);
        left.setBalance(0);
        tree.setLeft(left);

        AvlNode right = new AvlNode();
        ElementType typeRight = new ElementType();
        typeRight.setKey(3);
        right.setElement(typeRight);
        right.setHeight(1);
        right.setBalance(0);
        tree.setRight(right);

        AvlNode max = avlUtils.findMax(tree);
        Assert.assertThat(max.getKey(), equalTo(3));
    }

    @Test
    public void testFind() {
        AVLUtils avlUtils = new AVLUtils();
        AvlNode tree = new AvlNode();
        ElementType type = new ElementType();
        type.setKey(1);
        tree.setElement(type);
        tree.setHeight(1);
        tree.setBalance(2);

        AvlNode left = new AvlNode();
        ElementType typeLeft = new ElementType();
        typeLeft.setKey(2);
        left.setElement(typeLeft);
        left.setHeight(1);
        left.setBalance(0);
        tree.setLeft(left);

        AvlNode right = new AvlNode();
        ElementType typeRight = new ElementType();
        typeRight.setKey(3);
        right.setElement(typeRight);
        right.setHeight(1);
        right.setBalance(0);
        tree.setRight(right);

        AvlNode found = avlUtils.find(typeRight, tree);
        Assert.assertThat(found.getKey(), equalTo(3));
    }
}
