         BEGIN NAME=xxx2,VERSION=A1
***********************************************************************
*                                                                     *
*   PROGRAM PURPOSE     : DRIVE ENTRIES FROM SCRIPTS INTO CRESC's     *
*                                                                     *
*                                                                     *
***********************************************************************
*   DESCRIPTION :  VALIDATES THE INPUT MESSAGE.  BUILDS THE Z MESSAGE *
*                  AND CREATE SYCHRONOUS ECB's. CHECKS FOR ZEXEC AND  *
*                  IF PRESENT CALLS xxx3                              *
***********************************************************************
***********************************************************************
*     DATA MACROS                                                     *
***********************************************************************
         PRINT GEN
         AM0SG REG=R1                 SCRIPT MESSAGE
         MI0MI REG=R5                 INPUT BLOCK
         LINEQ                        FOR #EOM ETC.
***********************************************************************
*  THE INPUT FIELDS BELOW ARE COMING IN FROM xxx1 AND MUST MATCH      *
*  xxx1 parm_interface. THE REST OF THE DSECT CONTROL SUBQ AND OUTPUT *
***********************************************************************
         DSECT 2
*   START OF parm_interface MATCHING FIELDS
PARM_BLK DS    0H                     INPUT PARM BLOCK
FIL_NAME DS    CL70                   FILE NAME
LOC      DS    CL3                    LOCATION
SUBQ     DS    CL70                   SUBSTITUTION Q
OPT      DS    CL3                    OPTION
*   END OF parm_interface MATCHING FIELDS
SUBQPTR  DS    F                      CURRENT POINTER INTO SUBQ
SUBQI    DS    H                      NUMBER OF ?
SUBQO    DS    H                      NUMBER OF SUB CHARS
OPTVAL   DS    CL3                    OPT-VAL VAL IS ONLY OPTION
MSG_LINE DS    CL120                  MESSAGE LINE FOR WTOPC
*
$IS$     CSECT
         USING PARM_BLK,R15
***********************************************************************
*  SYSTEM VALIDATION AND SUBQ INITIALIZATION IF NO MESSAGE IS ON D5   *
***********************************************************************
xxx20010 EQU   *
         LEVTA LEVEL=5,INUSE=xxx20100 NO MESSAGE MUST BE INIT CALL
         L     R15,CE1CRF              ADDRESS INPUT MSG PARMS 002
         CLC   OPT,SILENT
         BE    xxx20020
         WTOPC TEXT='VALIDATING SYSTEM'
xxx20020 EQU   *
         CINFC R,CMMSYSID,F,REG=R15   SETUP AND VALIDATE SYSTEM
         CLC   0(8,R15),8(R15)        xxxSHA?
         BE    xxx20600               YES ERROR
         L     R15,CE1CRF             BASE INPUT MESSAGE ZURES
         MVC   OPTVAL,OPT             SAVE OPT-VAL IF INPUT
         LA    R14,SUBQ               GET ADDRESS OF SUBSTITUTION DATA
         ST    R14,SUBQPTR            SAVE IN EBW
         LA    R7,L'SUBQ              GET LEN OF SUBQ FIELD
xxx20050 EQU   *
         CLI   0(R14),X'00'           IS THERE SUBQ INPUT
         BE    xxx20060               NO
         LA    R14,1(,R14)            YES BUMP ONE
         BCT   R7,xxx20050            REDUCE FROM TOTAL LEN
         B     xxx20700               WENT PAST LEN ALLOWED IN INPUT
xxx20060 EQU   *
         LA    R7,SUBQ                LOAD SUBQ ADDRESS
         SR    R14,R7                 FIND LEN OF SUBQ
         STH   R14,SUBQI              STORE LEN OF INPUT SUBSTITUTION Q
         BACKC                        GO BACK AND OPEN THE FILE
***********************************************************************
*  WE HAVE AN INCOMING MESSAGE BLOCK SO WE HAVE A MESSAGE TO WORK     *
***********************************************************************
xxx20100 EQU   *
         L     R1,CE1CR5              BASE THE MESSAGE
         LA    R2,AM0TXT              POINT AT THE TEXT
         XR    R3,R3                  CLEAR R3 FOR LEN
         LA    R7,RMXC381             GET MAX LENGTH                002
         CLC   0(L'NOWAIT,R2),NOWAIT  IS THIS A nowait/
         BE    xxx20130               YES
         CLC   0(L'NOWAITUP,R2),NOWAITUP  IS THIS A NOWAIT/
         BNE   xxx20150               NO
xxx20130 EQU   *
         L     R15,CE1CRF             BASE PARM_BLK TO CHECK OPT-VAL
         CLC   OPTVAL,VALIDATE        IS THIS A VALIDATION RUN
         BNE   xxx20140               NO START EXECUTION
         WTOPC TEXT='THE FOLLOWING ENTRY WILL BE EXECUTED IMMEDIATELY'
xxx20140 EQU   *
         LA    R2,L'NOWAIT(R2)        BUMP PAST TO GET TO MESSAGE
xxx20150 EQU   *
         LR    R4,R2                  SAVE START OF MESSAGE IN R4
***********************************************************************
*  FIND ACTUAL LENGTH AND CHECK FOR ? IN CASE WE NEED TO SUBSTITUTE   *
***********************************************************************
xxx20200 EQU   *
         CLI   0(R2),X'15'            EOM
         BE    xxx20300               YES
         CLI   0(R2),C'?'             SUBSTUTION QUESTION MARK PRESENT
         BNE   xxx20250               NO
         BAS   R5,xxx2SUBQ            GO SUBSTUTUTE USING INPUT SUBQ
         B     xxx20260               SKIP REG BUMP WAS DONE IN SUB
xxx20250 EQU   *
         LA    R2,1(,R2)              BUMP MESSAGE POINTER
         LA    R3,1(,R3)              BUMP LEN
xxx20260 EQU   *
         BCT   R7,xxx20200            LOOP UNTIL EOM
         B     xxx20340               WENT TOO FAR MESSAGE TOO LONG
***********************************************************************
*  CHECK FOR COMMENTS AND SLEEPS AND HANDLE VALIDATE ONLY OPT-VAL     *
***********************************************************************
xxx20300 EQU   *
         CLI   0(R4),C'*'             IS THIS A COMMENT LINE
         BE    xxx20400               YES JUST PRINT
         CLI   0(R4),C'#'             IS THIS A SCRIPT COMMENT
         BE    xxx20400               YES JUST PRINT
         CLC   0(L'SLEEP,R4),SLEEP    IS THIS A SLEEP REQ
         BE    xxx20380               YES DELAY AND DEFER
         CLC   0(L'SLEEPUPR,R4),SLEEPUPR
         BE    xxx20380               YES DELAY AND DEFER
xxx20305 EQU   *
         L     R15,CE1CRF             BASE PARM_BLK
         CLC   OPTVAL,VALIDATE        IS THIS A VALIDATION RUN
         BNE   xxx20310               NO START EXECUTION
         DEFRC                        COULD BE A BIG SCRIPT SO SLOW IT
         B     xxx20400               YES VALIDATE ONLY
***********************************************************************
*  WE HAVE A REAL MESSAGE ALL VALIDATED AND READY FOR CRESC           *
***********************************************************************
xxx20310 EQU   *
         MVC   0(2,R2),MSGCRLF        MOVE IN X'4E15' TO BE SURE NO BLK
         GETCC D2,L1,FILL=00          BUILD MESSAGES IN D2
         L     R5,CE1CR2              BASE MI0MI
         L     R15,CE1CRF             BASE PARM_BLK
         EX    R3,xxx2MVC             EXECUTE MOVE INTO NEW MI
         XC    MSG_LINE,MSG_LINE      CLEAR MESSAGE
         EX    R3,xxx2MSG             EXECUTE MSG MOVE WITH LEN
         STC   R3,MSG_LINE            STORE CALULATED LEN IN LINE
         WTOPC TEXTA=MSG_LINE         WRITE OUT MESSAGE GOING TO CRESC
         MVC   MI0ADR(3),=X'010000'   MOVE CRAS ADDRESS
         LA    R3,L'#EOM+CCPPRCL(R3)  GET LENGTH OF Z MSG
         STH   R3,MI0CCT              STORE LENGTH INTO CHAR COUNT
         STH   R3,AM0CCT              STORE LENGTH INTO CHAR COUNT
         MVC   AM0RID,=C'MI'          MOVE IN REC ID
         XR    R14,R14                CLEAR PARAMETER REGISTER
         XR    R15,R15                CLEAR PARAMETER REGISTER
         L     R4,CE1CR2              BASE MI0MI WITH R4 FOR CRESC
         LA    R5,381                 SIZE OF BLOCK BEING PASSED
         LA    R6,5                   TIMEOUT IN SECONDS
         SR    R7,R7                  NO RETURN BLOCK
         CLC   MI0ACC(L'ZEXEC),ZEXEC  IS THIS A ZEXEC
         BE    xxx20320               YES DRIVE INTO xxx3
         CLC   MI0ACC(L'ZEXECUPR),ZEXECUPR  IS THIS A ZEXEC
         BE    xxx20320               YES DRIVE INTO xxx3
         CRESC CVAA,DATA=(R4,R5),IS=SAME,WAIT=YES,TIMEOUT=(R6),        x
               RTNLST=(R7)
         B     xxx20330               RELEASE D2 DELAY AND DEFER
xxx20320 EQU   *
         CRESC xxx3,DATA=(R4,R5),IS=SAME,WAIT=YES,TIMEOUT=(R6),        x
               RTNLST=(R7)
xxx20330 EQU   *
         RELCC D2                     RELEASE D2 MESSAGE BLOCK MI
         B     xxx20450               DELAY DEFER AND RETURN
***********************************************************************
*  HANDLE MAX LENGTH ERROR AND SLEEP MESSAGES                         *
***********************************************************************
xxx20340 EQU   *
         WTOPC TEXT='WARNING - MESSAGE LENGTH EXCEEDS 375 CHARACTERS'
         B     xxx20400                WRITE MESSAGE
xxx20380 EQU   *

         L     R15,CE1CRF
         CLC   OPT,SILENT
         BE    xxx20390
         WTOPC TEXT='SLEEPING USING:'
xxx20390 EQU   *
         DLAYC xxx20400               DELAY AND PRINT SLEEP MESSAGE
***********************************************************************
*  WRITE OUT SLEEPS COMMENTS BLANK LINES AND ANY PROBLEM MESSAGES     *
***********************************************************************
xxx20400 EQU   *
         L     R15,CE1CRF
         XC    MSG_LINE,MSG_LINE       CLEAR MESSAGE
         EX    R3,xxx2MSG              MOVE INTO MSG
         STC   R3,MSG_LINE             PUT IN LEN
         WTOPC TEXTA=MSG_LINE          WRITE
         B     xxx20470                RETURN
***********************************************************************
*  DELAY AND DEFER BEFORE RETURNING FOR MORE BACK IN xxx1             *
***********************************************************************
xxx20450 EQU   *
         DLAYC xxx20460
xxx20460 EQU   *
         DEFRC
xxx20470 EQU   *
         BACKC                         RETURN TO xxx1
***********************************************************************
*  THIS SECTION EXITS AFTER ERRORS MESSAGES ARE SENT                  *
***********************************************************************
xxx20600 EQU   *
         WTOPC TEXT='ZURES CANNOT BE USED ON PRODUCTION'
         B     xxx20800
xxx20700 EQU   *
         WTOPC TEXT='SUBQ- INPUT VALUE EXCEEDS MAX VALUE OF 70'
xxx20800 EQU   *
         RELCC D5
         EXITC
***********************************************************************
*  EXECUTED MOVES FOR ZERO LENGTH DUE TO OR'ED PASS REGISTER WITH LEN *
***********************************************************************
xxx2MVC  MVC   MI0ACC(0),0(R4)          MOVE MESSAGE INTO BLK D5 CRESC
xxx2MSG  MVC   MSG_LINE+1(0),0(R4)      MOVE MESSAGE INTO BLK DF PRINT
***********************************************************************
*  THIS SUBROUTINE WILL SWITCH A ? WITH A BYTE OF INPUT SUBQ INPUT    *
***********************************************************************
xxx2SUBQ EQU   *
         L     R15,CE1CRF                BASE PARM_BLK ON F
         L     R14,SUBQPTR               LOAD SUBSTITUTION PTR
xxx2S100 EQU   *
         CLI   0(R2),C'?'                MARK?
         BNE   xxx2S150                  NO GO BACK
         CLI   0(R2),X'15'               EOM
         BE    xxx2S150                  GO BACK
         CLI   0(R2),C' '                SPACE
         BNE   xxx2S200                  NO LETS DO THE SUB
xxx2S150 EQU   *
         BR    R5                        RETURN
xxx2S200 EQU   *
         SR    R6,R6                     ZERO OUT
         LH    R6,SUBQI                  LOAD NUMBER OF INPUT CHARS
         CH    R6,SUBQZERO               ANY INPUT SUB CHARS FOR A ?
         BE    xxx2S250                  NO PRINT MESSAGE AND CONTINUE
         SH    R6,SUBQONE                SUBTRACT ONE WE ARE MOVING IN
         STH   R6,SUBQI                  SAVE AMOUNT NOW ONE LESS
         LH    R6,SUBQO                  LOAD UP NUMBER WE MOVED SO FAR
         LA    R6,1(,R6)                 ADD THIS ONE
         STH   R6,SUBQO                  SAVE COUNT OF OUTPUT DATA
         MVC   0(1,R2),0(R14)            MOVE IN SUB DATA
         LA    R2,1(,R2)                 BUMP TO NEXT BYTE
         LA    R3,1(,R3)                 BUMP FOR TOTAL MESSAGE LEN
         LA    R14,1(,R14)               BUMP PTR INTO SUBQ
         ST    R14,SUBQPTR               SAVE PTR
         B     xxx2S100                  KEEP GOING
xxx2S250 EQU   *
         WTOPC TEXT='ERROR - MISSING SUBQ INPUT FOR ? FOUND IN THE'
         WTOPC TEXT='        FOLLOWING ENTRY. ATTEMPTING EXECUTION'
         B     xxx20400                  PRINT BAD MESSAGE AND RETURN
***********************************************************************
*     DEFINED CONSTANTS                                               *
***********************************************************************
ZEXECUPR DC    C'ZEXEC'                  ZEXEC FOR COMPARE
SILENT   DC    C'SIL'                    SILENT OPT002
ZEXEC    DC    C'zexec'                  ZEXEC FOR COMPARE
SLEEP    DC    C'sleep'                  SLEEP FOR COMAPRE
SLEEPUPR DC    C'SLEEP'                  SLEEP FOR COMPARE
NOWAIT   DC    C'nowait/'                NOWAIT FOR COMPARE
NOWAITUP DC    C'NOWAIT/'                NOWAIT FOR COMPARE
VALIDATE DC    C'VAL'                    VALIDATION ONLY FLAG
SUBQONE  DC    H'1'                      USED TO ADD UP SUBSTITUTIONS
SUBQZERO DC    H'0'                      USED FOR COMPARES
MSGCRLF  DC    X'4E15'                   CRLF
***********************************************************************
*     THE END                                                         *
***********************************************************************
         LTORG
         FINIS
         END
