/*
 * Migration: 2020 by IT Modernisation Services GmbH Hamburg, Germany.
 */
package com.itms.demo.xxx;

/**
 * @author IT Modernisation Services GmbH
 *
 *          Entity      xxx2
 *          Transformer IT Modernisation Services GmbH
 *                      Hamburg, Germany
 *          On          09.09.2020
 *          Using       njema Version 4.6
 */
public class xxx2 {

    /*
     * *********************************************************************
     *
     *    PROGRAM PURPOSE     : DRIVE ENTRIES FROM SCRIPTS INTO CRESC's
     *
     *
     * *********************************************************************
     *    DESCRIPTION :  VALIDATES THE INPUT MESSAGE.  BUILDS THE Z MESSAGE
     *                   AND CREATE SYCHRONOUS ECB's. CHECKS FOR ZEXEC AND
     *                   IF PRESENT CALLS xxx3
     * *********************************************************************
     */
    private static final String SILENT = "SIL";
    private static final String NJEMA_VALIDATE = "VAL";
    private static final String SLEEP = "sleep";
    private static final String NOWAIT = "nowait";
    private static final String NOWAITUP = "NOWAIT";
    private static final String SLEEPUPR = "SLEEP";

    private int subqPos;

    /**
     * @param am0txt LINE
     * @param subq SUBSTITUTION Q
     * @param opt OPTION
     */
    public void execute(String am0txt, String subq, String opt) {

        // ***********************************************************************
        // *  SYSTEM VALIDATION AND SUBQ INITIALIZATION IF NO MESSAGE IS ON D5   *
        // ***********************************************************************
        if (am0txt.startsWith("          ")) {  // NO MESSAGE MUST BE INIT CALL
            subqPos = 0;
            if (!opt.equals(SILENT)) {
                System.out.println("VALIDATING SYSTEM");
            }
            return;
        }

        // ***********************************************************************
        // *  WE HAVE AN INCOMING MESSAGE BLOCK SO WE HAVE A MESSAGE TO WORK     *
        // ***********************************************************************
        if (am0txt.startsWith(NOWAIT)) {
            if (opt.equals(NJEMA_VALIDATE)) { // IS THIS A VALIDATION RUN
                System.out.println("THE FOLLOWING ENTRY WILL BE EXECUTED IMMEDIATELY"); // NO START EXECUTION
            }

            am0txt = am0txt.substring(6);
        }

        if (am0txt.startsWith(NOWAITUP)) {
            am0txt = am0txt.substring(6);
        }

        // ***********************************************************************
        // *  FIND ACTUAL LENGTH AND CHECK FOR ? IN CASE WE NEED TO SUBSTITUTE   *
        // ***********************************************************************
        int eom = am0txt.indexOf(String.valueOf((char) 15));
        if (eom <= 0) {
            xxx20340(am0txt);
            return;
        }

        am0txt = am0txt.substring(0, eom);

        // ***********************************************************************
        // *  CHECK FOR COMMENTS AND SLEEPS AND HANDLE VALIDATE ONLY OPT-VAL     *
        // ***********************************************************************
        if (am0txt.startsWith("*") || am0txt.startsWith("#")) {
            // IS THIS A COMMENT LINE
            // IS THIS A SCRIPT COMMENT
            xxx20400(am0txt); // YES JUST PRINT
            return;
        }

        if (am0txt.startsWith(SLEEP) || am0txt.startsWith(SLEEPUPR)) { // IS THIS A SLEEP REQ
            System.out.println("SLEEPING USING:"); // YES DELAY AND DEFER
            xxx20400(am0txt);
            return;
        }

        // SUBSTITUTION
        while(am0txt.contains("?")) {
            am0txt = substitute(am0txt, subq);
        }

        if (!opt.equals(NJEMA_VALIDATE)) { // IS THIS A VALIDATION RUN
            // ***********************************************************************
            // *  WE HAVE A REAL MESSAGE ALL VALIDATED AND READY FOR CRESC           *
            // ***********************************************************************
            System.out.println(am0txt);//  WRITE OUT MESSAGE GOING TO CRESC
            return;
        }

        xxx20400(am0txt); //  YES VALIDATE ONLY
    }

    /**
     * *********************************************************************
     *  THIS SUBROUTINE WILL SWITCH A ? WITH A BYTE OF INPUT SUBQ INPUT    *
     * *********************************************************************
     */
    private String substitute(String am0txt, String subq) {
        if (subqPos + 1 > subq.length()) {
            System.out.println("ERROR - MISSING SUBQ INPUT FOR ? FOUND IN THE\n         FOLLOWING ENTRY. ATTEMPTING EXECUTION");
        } else {
            am0txt = am0txt.substring(0, am0txt.indexOf("?")) + subq.charAt(subqPos) + am0txt.substring(am0txt.indexOf("?") + 1);
            subqPos++;
        }
        return am0txt;
    }

    /**
     * *********************************************************************
     *  HANDLE MAX LENGTH ERROR AND SLEEP MESSAGES                         *
     * *********************************************************************
     */
    private void xxx20340(String am0txt) {
        System.out.println("WARNING - MESSAGE LENGTH EXCEEDS 375 CHARACTERS");
        xxx20400(am0txt);
    }
    /**
     * *********************************************************************
     *  WRITE OUT SLEEPS COMMENTS BLANK LINES AND ANY PROBLEM MESSAGES     *
     * *********************************************************************
     */
    private void xxx20400(String am0txt) {
        System.out.println(am0txt); //  WRITE
    }
}
